//$Id: CMidiEvent.cpp,v 1.8 2007/02/08 21:08:09 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMidiEvent.hpp"
using Exponent::Midi::CMidiEvent;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMidiEvent, CCountedObject);

//	===========================================================================
CMidiEvent::CMidiEvent(const long status, const long value, const long subValue, const long channel, const long delta)
		  : m_status(0)
		  , m_value(0)
		  , m_subValue(0)
		  , m_channel(0)
		  , m_timeDelta(0)
		  , m_pitchBend(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CMidiEvent);
	this->setEvent(status, value, subValue, channel, delta);
}

//	===========================================================================
CMidiEvent::CMidiEvent(const CMidiEvent &event)
		  : m_status(0)
		  , m_value(0)
		  , m_subValue(0)
		  , m_channel(0)
		  , m_timeDelta(0)
		  , m_pitchBend(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CMidiEvent);
	this->setEvent(event.m_status, event.m_value, event.m_subValue, event.m_channel, event.m_timeDelta);
}

//	===========================================================================
CMidiEvent::~CMidiEvent()
{
	EXPONENT_CLASS_DESTRUCTION(CMidiEvent);
}

//	===========================================================================
int CMidiEvent::compareMidiEvents(const CMidiEvent **event1, const CMidiEvent **event2)
{
	if (*event1 == *event2)
	{
		return 0;
	}
	else if (*event1 == NULL)
	{
		return 1;
	}
	else if (*event2 == NULL)
	{
		return -1;
	}
	else
	{
		CMidiEvent *ev1 = (CMidiEvent *)(*event1);
		CMidiEvent *ev2 = (CMidiEvent *)(*event2);

		if (ev1->getTimeDelta() == ev2->getTimeDelta())
		{
			return 0;
		}
		else if (ev1->getTimeDelta() < ev2->getTimeDelta())
		{
			return -1;
		}
		else
		{
			return 1;
		}
	}
	return 0;
}

//	===========================================================================
bool CMidiEvent::operator < (const CMidiEvent &event)
{ 
	return (m_timeDelta < event.m_timeDelta); 
}

//	===========================================================================
bool CMidiEvent::operator > (const CMidiEvent &event) 
{ 
	return (m_timeDelta > event.m_timeDelta); 
}

//	===========================================================================
bool CMidiEvent::operator <= (const CMidiEvent &event) 
{ 
	return (m_timeDelta <= event.m_timeDelta);
}

//	===========================================================================
bool CMidiEvent::operator >= (const CMidiEvent &event) 
{ 
	return (m_timeDelta >= event.m_timeDelta); 
}

//	===========================================================================
CMidiEvent &CMidiEvent::operator = (const CMidiEvent &event)
{
	if (this != &event)
	{
		this->setEvent(event.m_status, event.m_value, event.m_subValue, event.m_channel, event.m_timeDelta);
	}
	return (*this);
}

//	===========================================================================
bool CMidiEvent::operator == (const CMidiEvent &event)
{
	return this->isSynchronousWith(event);
}

//	===========================================================================
bool CMidiEvent::operator != (const CMidiEvent &event)
{
	return !this->isSynchronousWith(event);
}

//	===========================================================================
void CMidiEvent::getObjectDescription(char *string, const long size) const
{
	CString description;
	if (this->isNoteOff())
	{
		description.setStringWithFormat("[Note Off       : Note(%03li), Velocity(%03li), Channel(%03li), Delta(%03li)]", m_value, m_subValue, m_channel, m_timeDelta);
	}
	else if (this->isNoteOn())
	{
		description.setStringWithFormat("[Note On        : Note(%03li), Velocity(%03li), Channel(%03li), Delta(%03li)]", m_value, m_subValue, m_channel, m_timeDelta);
	}
	else if (this->isControlChange())
	{
		description.setStringWithFormat("[Control Change : CC(%03li), Value(%03li), Channel(%03li), Delta(%03li)]", m_value, m_subValue, m_channel, m_timeDelta);
	}
	else
	{
		description.setStringWithFormat("[Other Message  : Status(%03li), Value(%03li), SubValue(%03li), Channel(%03li), Delta(%03li)]", m_status, m_value, m_subValue, m_channel, m_timeDelta);
	}
	description.getString(string, size);
}